package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import app.firezone.synk.network.Activities.NotificationInfoActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemNotificationBinding;
import app.firezone.synk.network.model.NotificationModel;

import java.util.ArrayList;

public class NotificationAdapter extends RecyclerView.Adapter<NotificationAdapter.holder> {
    Context mContext;
    ArrayList<NotificationModel> mlist = new ArrayList<>();

    public NotificationAdapter(Context mContext, ArrayList<NotificationModel> mlist) {
        this.mContext = mContext;
        this.mlist = mlist;
    }


    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_notification,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        NotificationModel model = mlist.get(position);

        holder.binding.headlinetext.setText(model.getHeadline());
        holder.binding.subtext.setText(model.getSubTitle());


        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent =  new Intent(mContext, NotificationInfoActivity.class);
                intent.putExtra("title", model.getHeadline());
                intent.putExtra("message", model.getSubTitle());
                intent.putExtra("images", model.getImgUrl());
                mContext.startActivity(intent);
            }
        });


    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        ItemNotificationBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = ItemNotificationBinding.bind(itemView);
        }
    }
}
